/*
 * Decompiled with CFR 0.152.
 */
package com.deokma.MoltenVents.core;

import com.deokma.MoltenVents.MoltenVents;
import com.google.gson.JsonObject;
import com.simibubi.create.Create;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_6796;

public class MoltenVentsPlacedData
implements SimpleSynchronousResourceReloadListener {
    public static final Map<class_2960, class_6796> PLACED_FEATURES = new HashMap<class_2960, class_6796>();

    public class_2960 getFabricId() {
        return new class_2960("molten_vents", "placed_features");
    }

    public void method_14491(class_3300 manager) {
        try {
            PLACED_FEATURES.clear();
            String folderPath = "worldgen/placed_feature";
            MoltenVents.LOGGER.info("Loading placed features from folder: {}", (Object)folderPath);
            for (class_2960 id : manager.method_14488(folderPath, path -> path.method_12832().endsWith(".json")).keySet()) {
                try {
                    List resources = manager.method_14489(id);
                    for (class_3298 resource : resources) {
                        InputStream stream = resource.method_14482();
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                            JsonObject json = (JsonObject)Create.GSON.fromJson((Reader)reader, JsonObject.class);
                            if (json == null) continue;
                            if (!json.has("feature")) {
                                MoltenVents.LOGGER.warn("Missing 'feature' field in {}", (Object)id);
                                continue;
                            }
                            String featureStr = json.get("feature").getAsString();
                            if (!featureStr.startsWith("molten_vents:")) {
                                MoltenVents.LOGGER.debug("Skipping unnecessary file: {}", (Object)id);
                                continue;
                            }
                            String path2 = id.method_12832();
                            String filename = path2.substring(path2.lastIndexOf(47) + 1, path2.lastIndexOf(46));
                            class_2960 placedFeatureId = new class_2960("molten_vents", filename);
                            MoltenVents.LOGGER.info("Registered PlacedFeature: {}", (Object)placedFeatureId);
                        }
                        finally {
                            if (stream == null) continue;
                            stream.close();
                        }
                    }
                }
                catch (Exception e) {
                    MoltenVents.LOGGER.error("Error loading placed feature from {}: {}", (Object)id, (Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            MoltenVents.LOGGER.error("General error while loading placed features: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
    }
}

